;Copyright 1997, 1999 by Henter-Joyce, Inc.
;Created 11/11/97 by Andres Gonzalez, Carl Wise, Dusty Voorhees, Gordon Kent, George Bitzer
;Updated and modified 3/29/99 By DB
include "CakeAud.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"
include "cakeaud.jsm" ; message file for CakeWalk

Globals
	int GlobalCakeWalkFirstTime

Function AutoStartEvent ()
if (GlobalCakeWalkFirstTime == 0) then
	let GlobalCakeWalkFirstTime = 1
	if (GetVerbosity () == beginner) then
		Say (msgc1, OT_HELP) ; "To best reed each view make sure the child windows are maximized"
		Say (msgc2, OT_HELP) ; "To maximize the child windows press Alt+- followed by X"
		Say (msgc3, OT_HELP) ; "In the track view, you need to expand the track listings to show all fields"
; msgc4 = "To expand the track view press" 
		Say (msgc4 + (GetScriptKeyName ("ExpandTrackView")), OT_HELP)
	EndIf
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames("Cake Walk Audio")
EndScript

Script ExpandTrackView ()
var 
	handle hwnd, 
	int nRow, 
	int nColumn, 
	int nCursor
let nCursor = GetActiveCursor ()
let hwnd = GetFirstChild(GetFirstChild (GetAppMainWindow (GetFocus())))

if (hWnd) then
	;wc1 = "TV.1"
	while (hWnd && GetWindowClass (hWnd) != wc1)
		let hWnd = GetNextWindow(hWnd)
	EndWhile 
	
	let hWnd = GetFirstChild(hWnd)
	;wc2 = "TV.3"
	while (hWnd && GetWindowClass (hWnd) != wc2)
		let hWnd = GetNextWindow(hWnd)
	EndWhile 
	;wc2 = "TV.3"
	if (GetWindowClass(hWnd) == wc2) then
		let nRow = GetWindowLeft(hwnd) + 2
		let nColumn = GetWindowTop(hwnd) + 10
	
		JAWSCursor()
		SaveCursor()
		MoveTo (nRow, nColumn)
		if (!IsLeftButtonDown ()) then
			LeftMouseButtonLock  ()
		endif
		MoveTo (GetWindowRight(GetAppMainWindow(GetFocus()))-50, GetWindowTop(hwnd)+10)
		LeftMouseButtonLock()
		SetActiveCursor ((nCursor))	
		Say (msgc5, OT_MESSAGE) ; "Track view re sized"
		return
	endif
endif
Say (msgc6, OT_MESSAGE) ; "Cannot Find Sizing border"
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
If (GetControlID(hwnd) == ID_TIME_FORMAT) then
	;wc3 = "SemiStatic"
	if (GetWindowClass(hwnd) == wc3) then
		let hTimeFormat = hwnd
	endif
elIf (GetControlID(hwnd) == ID_NOW) then
;wc3 = "SemiStatic"
	if (GetWindowClass(hwnd) == wc3) then
		let hNow = hwnd
	endif
elIf (GetControlID(hwnd) == ID_FROM) then
	;wc3 = "SemiStatic"
	if (GetWindowClass(hwnd) == wc3) then
		let hFrom = hwnd
	endif
elIf (GetControlID(hwnd) == ID_THROUGH) then
	if (GetWindowClass(hwnd) == wc3) then
		let hThrough = hwnd
	endif
elIf (GetControlID(hwnd) == ID_TEMPO) then
	if (GetWindowClass(hwnd) == wc3) then
		let hTempo = hwnd
	endif
elIf (GetControlID(hwnd) == ID_TEMPO_RATIO_1) then
	if (GetWindowClass(hwnd) == wc3) then
		let hRatio1 = hwnd
	endif
elIf (GetControlID(hwnd) == ID_TEMPO_RATIO_2) then
	if (GetWindowClass(hwnd) == wc3) then
		let hRatio2 = hwnd
	endif
elIf (GetControlID(hwnd) == ID_TEMPO_RATIO_3) then
	if (GetWindowClass(hwnd) == wc3) then
		let hRatio3 = hwnd
	endif
elif (GetControlID(hwnd) == ID_TRACK_VIEW) then
	let hTrackView = hwnd
endif
	SayNonHighlightedText(hwnd, buffer)
EndFunction

Script SayTimeFormat ()
Say (msgc7, OT_MESSAGE) ; "Time format is"
SayWindow (hTimeFormat, READ_EVERYTHING)
EndScript

Script SayNow ()
Say (msgc8, OT_MESSAGE) ; "Now marker is"
SayWindow (hNow, READ_EVERYTHING)
EndScript

Script SayFrom ()
Say (msgc9, OT_MESSAGE) ; " Frum marker is"
SayWindow (hFrom, READ_EVERYTHING)
EndScript

Script SayThrough ()
Say (msgc10, OT_MESSAGE) ; "through marker is"
SayWindow (hThrough, READ_EVERYTHING)
EndScript

Script SayTemp ()
Say (msgc11, OT_MESSAGE) ; "tempo is"
SayWindow (hTempo, READ_EVERYTHING)
EndScript

Script SayRatio1 ()
Say (msgc12, OT_MESSAGE) ; "tempo ratio 1 is"
SayWindow (hRatio1, READ_EVERYTHING)
EndScript

Script MoveToRatio1 ()
MoveToWindow (hRatio1)
LeftMouseButton ()
PCCursor()
EndScript

Script SayRatio2 ()
Say (msgc13, OT_MESSAGE) ; "tempo ratio 2 is"
SayWindow (hRatio2, READ_EVERYTHING)
EndScript

Script MoveToRatio2 ()
MoveToWindow (hRatio2)
LeftMouseButton ()
PCCursor()
EndScript

Script SayRatio3 ()
Say (msgc14, OT_MESSAGE) ; "tempo ratio 3 is"
SayWindow (hRatio3, READ_EVERYTHING)
EndScript

Script MoveToRatio3 ()
MoveToWindow (hRatio3)
LeftMouseButton ()
PCCursor()
EndScript

Function SayFocusedWindow ()
var
	string TheClass

;wn1 = "Event List"
if (GetWindowName(GetRealWindow(GetFocus())) == wn1) then
	SetJcfOption (OPT_TYPING_ECHO, OFF)
else
	SetJcfOption (OPT_TYPING_ECHO, OFF)
endif
;wn2 = "EFFECTS"
if (GetWindowName (GlobalFocusWindow) == wn2) then
	SayWindowTypeAndText (GlobalFocusWindow)
	SaveCursor ()
	JawsCursor ()
	MoveToWindow (GetFirstChild (GlobalFocusWindow))
	LeftMouseButton ()
	RestoreCursor ()
	return
endif
let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
;wc4 = "TV.2"
;wc5 = "EV.2"
if ((TheClass == wc4) || (TheClass == wc5)) then
	if (GetWindowTypeCode (GlobalFocusWindow) == WT_EDIT) then
		Say (msgc15, OT_MESSAGE) ; "Edit"
		return
	EndIf
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Script Tab ()
;wn2 = "EFFECTS"
if (GetWindowName (GetParent (GlobalFocusWindow)) == wn2) then
	SwitchControl ()
	return
EndIf
{Tab}
EndScript

Script ShiftTab ()
;wn2 = "EFFECTS"
if (GetWindowName (GetParent(GlobalFocusWindow)) == wn2) then
	SwitchControl ()
	return
EndIf
{Shift Tab}
EndScript

Function SwitchControl ()
var
	handle WinHandle,
	int x,
	int y
SaveCursor ()
JawsCursor ()
let WinHandle = GetNextWindow (GetFocus ())
if WinHandle then
	let x = GetWindowLeft (WinHandle)
	let y = GetWindowTop (WinHandle)
	MoveTo (x+3, y+3)
	LeftMouseButton ()
	return
EndIf
let WinHandle = GetPriorWindow (GetFocus ())
if WinHandle then
	let x = GetWindowLeft (WinHandle)
	let y = GetWindowTop (WinHandle)
	MoveTo (x+3, y+3)
	LeftMouseButton ()
EndIf
EndFunction

Script DragAndDrop ()
var
	int x,
	int y,
	String strObjectName
if (DragAndDropSet == false) then
	let DragFromX = GetCursorCol ()
	let DragFromY = GetCursorRow ()
	let DragObject = GetField ()
	let DragAndDropSet = true
; msg412 = "place the JAWS or PC cursor in the drop location and press " 
	Say (msg412 + GetCurrentScriptKeyName () + msg413, OT_MESSAGE)
	return
EndIf
SaveCursor ()
let x = GetCursorCol ()
let y = GetCursorRow ()
JawsCursor ()
; make sure that the left mouse button is unlocked
If IsLeftButtonDown () then
	LeftMouseButtonLock ()
	pause ()
EndIf
MoveTo (DragFromX, DragFromY)
let strObjectName = GetField ()
if strObjectName != DragObject then
	Let DragAndDropSet = false
	Say (msg415, OT_MESSAGE) ; "Object to be dragged not found"
	Say (msg416, OT_MESSAGE) ; "this may be because it has been covered by another window"
	Say (msg417, OT_MESSAGE) ; "drag and drop action has been canceled"
	return
EndIf
Delay (2)
LeftMouseButtonLock () ; lock it down
Delay (2)
MoveTo (x,y)
RestoreCursor ()
;msg418 = "dragging "
Say (Msg418 +strObjectName+msg419, OT_MESSAGE)
SayField ()
Delay (2)
LeftMouseButtonLock () 
Let DragAndDropSet = false
EndScript

Void Function SayHeader ()
var
	handle hwnd
let hwnd = GetFocus()
if (GetWindowTypeCode (hwnd) == WT_EDIT) then
	let hwnd = GetParent(hWnd)
EndIf
SaveCursor ()
InvisibleCursor ()
MoveToWindow (hwnd)
SayTextBetween (GetFocusRectLeft (hwnd), GetFocusRectRight (hwnd))
EndFunction

Script SayNextCharacter() 
var
	Handle WinHandle,
	string TheClass,
	int TheTypeCode
NextCharacter ()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
;wc4 = "TV.2"
if ((TheClass == wc4) 
;wc5 = "EV.2"
	|| (TheClass == wc5)) then
	if (GlobalMenuMode == menu_inactive) then
		SayHeader ()
		SayFocusRect (WinHandle)
		return
	EndIf
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayPriorCharacter() 
var
	Handle WinHandle,
	string TheClass,
	int TheTypeCode
PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
;wc4 = "TV.2"
if ((TheClass == wc4) 
	;wc5 = "EV.2"
	|| (TheClass == wc5)) then
	if (GlobalMenuMode == menu_inactive) then
		SayHeader ()
		SayFocusRect (WinHandle)
		return
	EndIf
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
  	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayNextLine() 
var
	handle WinHandle,
	string TheClass,
	int TheTypeCode
NextLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if  not IsPCCursor () then
	SayLine ()
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
;wc4 = "TV.2"
if ((TheClass == wc4) 
	;wc5 = 
	|| (TheClass == wc5)) then
	if (GlobalMenuMode == menu_inactive) then
		SayCell (1)
		SayFocusRect (WinHandle)
		return
	EndIf
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayPriorLine () 
var
	handle WinHandle,
	string TheClass,
	int TheTypeCode
PriorLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine()
	return
endif
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
;wc4 = "TV.2"
if ((TheClass == wc4) 
	;wc5 = "EV.2"
	|| (TheClass == wc5)) then
	if (GlobalMenuMode == menu_inactive) then
		SayCell (1)
		SayFocusRect (WinHandle)
		return
	EndIf
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible() then
	SayLine()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
if ((TheTypeCode == WT_TREEVIEW) ||
	(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
	(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
EndIf
EndScript

Script SayWord ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
if IsPCCursor () then
	; wc4 = "TV.2"
	if ((TheClass == wc4) 
	;wc5 = "EV.2"
		|| (TheClass == wc5)) then
		if (GlobalMenuMode == menu_inactive) then
			SayFocusRect (WinHandle)
			return
		EndIf
	EndIf
EndIf
If (IsSameScript ()) Then
	SpellWord()
	AddHook (HK_SCRIPT, "SpellWordHook")
Else
	SayWord()
EndIf
EndScript

Script SayCellCoordAndContent ()
SayCell (1)
SayHeader ()
SayFocusRect (GetCurrentWindow ())
EndScript

Script MoveToTrackColumn ()
	MoveToColumn(0)
EndScript

Script MoveToNameColumn ()
	MoveToColumn(1)
EndScript

Script MoveToStatusColumn ()
	MoveToColumn(2)
EndScript

Script MoveToSourceColumn()
	MoveToColumn(3)
EndScript

Script MoveToKeyColumn ()
	MoveToColumn(4)
EndScript

Script MoveToVelColumn ()
	MoveToColumn(5)
EndScript

Script MoveToTimeColumn ()
	MoveToColumn(6)
EndScript

Script MoveToPortColumn ()
	MoveToColumn(7)
EndScript

Script MoveToChannelColumn ()
	MoveToColumn(8)
EndScript

Script MoveToBankColumn ()
	MoveToColumn(9)
EndScript

Script MoveToPatchColumn()
;wc4 = "TV.2"
	if (GetWindowClass(GetFocus())== wc4) then
		MoveToColumn(10)
	else
		PerformScript SayCurrentHotKey()
	endif
EndScript

Script MoveToVolumeColumn ()
;wc4 = "TV.2"
	if (GetWindowClass(GetFocus())== wc4) then
		MoveToColumn(11)
	else
		PerformScript SayAppVersion()	
	endif
EndScript

Script MoveToPanColumn ()
	MoveToColumn(12)
EndScript

Script MoveToSizeColumn ()
	MoveToColumn(13)
EndScript

Void Function MoveToColumn (int nColumn) ;nColumn is 0 indexed
var 
	int nSafety
let nSafety = 0
;wc4 = "TV.2"
If (GetWindowClass(GetFocus()) == wc4) then
	while (nSafety < 13)
		{Left Arrow}
		let nSafety = nSafety + 1
	endwhile
	;Move to desired column
	let nSafety = 0
	while (nSafety < nColumn)
		{Right Arrow}
		let nSafety = nSafety + 1
	endwhile
	Pause()
	SayHeader()
	SayChunk()
endif
EndFunction

Void Function SayCell (int nCellNumber)
var
	int c
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPC ()
if nCellNumber then
	JawsHome ()
	while (c<nCellNumber-1)
		NextChunk ()
		let c = c+1
	EndWhile
EndIf
SayChunk ()
EndFunction

Script ScreenSensitiveHelp ()
if (IsSameScript ()) then
	AppFileTopic ()
return
endif

;wc4 = "TV.2"
If (GetWindowClass(GetFocus()) == wc4) then
	Say (msgc16, OT_HELP) ; "You are in the Track view of Cakewalk."
	Say (msgc17, OT_HELP) ; "Use the left & right arrows to move between fields within a track."
	Say (msgc18, OT_HELP) ; "Use the up and down arrows to move from track to track."
	Say (msgc19, OT_HELP) ; "The Home key will take you to track 1."
	Say (msgc20, OT_HELP) ; "The End key will take you to track 256."
	Say (msgc21, OT_HELP) ; "When in the port, channel, bank or patch fields, pressing enter will open the track properties dialog."
	Say (msgc22, OT_HELP) ; "All other fields can be edited by typing while in the field."
	Say (msgc23, OT_HELP) ; "Key field settings can be adjusted in increments of 12 (1 Octave) by using the left and right brackets."
	Say (msgc24, OT_HELP) ; "Velosity & Time field settings can be adjusted in increments of 10 by using the left and right brackets."
;wc5 = "EV.2"
ElIf (GetWindowClass(GetFocus()) == wc5) then
	Say (msgc25, OT_HELP) ; "You are in the Event List of Cakewalk."
	Say (msgc26, OT_HELP) ; "Use the left & right arrows to move between fields within an event."
	Say (msgc27, OT_HELP) ; "Use the up and down arrows to move from event to event."
	Say (msgc28, OT_HELP) ; "Pressing Home will keep you in the current field & move you to the first event on the current list"
	Say (msgc29, OT_HELP) ; "Pressing End will keep you in the current field & move you to the last event on the current list"
	Say (msgc30, OT_HELP) "To hear the current event & move to next event press Shift+Spacebar"
	Say (msgc31, OT_HELP) ; "To move through & hear the events press and hold the Shift key"
	Say (msgc32, OT_HELP) ; "Press and release the spacebar to proceed through the events one at a time"
	Say (msg33, OT_HELP) ; "To insert an event press Insert+Number 3 followed by Insert"
	Say (msgc34, OT_HELP) ; "To edit an event select the field to be edited and press Enter"
;wc6 = "SystreeView32"
ElIf (GetWindowClass(GetFocus()) == wc6) then
	Say (msgc35, OT_HELP) ; "You are in the Effects Window of Cakewalk."
	Say (msgc36, OT_HELP) ; "There are two treeviews in this view."
	Say (msgc37,  OT_HELP) ; "You can use tab to switch between the two treeviews."
	Say (msgc38, OT_HELP) ; "The left pane shows the Effects Loops and Track Inserts."
	Say (msgc39, OT_HELP) ; "The right pane contains a list of all effects currently on your system."
	Say (msgc40, OT_HELP) ; "use the up or down arrows to read through the items"
	Say (msgc41, OT_HELP) ; "or press the first letter to jump through the list"
	Say (msgc42, OT_HELP) ; "use the right or left arrows to open or close an item"
	Say (msgc43, OT_HELP) ; "Selecting an effect loop and pressing Enter opens that effect loops property dialog"
Else
	PerformScript ScreenSensitiveHelp()
EndIf
EndScript

Script HotKeyHelp ()
;wc4 = "TV.2"
If (GetWindowClass(GetFocus()) == wc4) then
	Say (msgc44, OT_HELP) ; "Use the following keys to move to the desired column"
; msgc45 = "Track column press "
	Say (msg45+(GetScriptKeyName ("MoveToTrackColumn")), OT_HELP)
; msgc46 = "Name column press "
	Say (msgc46+(GetScriptKeyName ("MoveToNameColumn")), OT_HELP)
; msgc47 = "Status column press "
	Say (msgc47+(GetScriptKeyName ("MoveToStatusColumn")), OT_HELP)
; msgc48 = "Source column press "
	Say (msgc48+(GetScriptKeyName ("MoveToSourceColumn")), OT_HELP)
; msgc49 = "Key column press "
	Say (msgc49+(GetScriptKeyName ("MoveToKeyColumn")), OT_HELP)
; msgc50 = "Velocity column press "
	Say (msgc50+(GetScriptKeyName ("MoveToVelColumn")), OT_HELP)
; msgc51 = "Time column press "
	Say (msgc51+(GetScriptKeyName ("MoveToTimeColumn")), OT_HELP)
; msgc52 = "Port column press "
	Say (msgc52+(GetScriptKeyName ("MoveToPortColumn")), OT_HELP)
; msgc53 = "Channel column press "
	Say (msgc53+(GetScriptKeyName ("MoveToChannelColumn")), OT_HELP)
; msgc54 = "Bank column press "
	Say (msgc54+(GetScriptKeyName ("MoveToBankColumn")), OT_HELP)
; msgc55 = "Patch column press "
	Say (msgc55+(GetScriptKeyName ("MoveToPatchColumn")), OT_HELP)
; msgc56 = "Volume column press "
	Say (msgc56+(GetScriptKeyName ("MoveToVolumeColumn")), OT_HELP)
; msgc57 = "Pan column press "
	Say (msgc57+(GetScriptKeyName ("MoveToPanColumn")), OT_HELP)
; msgc58 = "Size column press "
	Say (msgc58+(GetScriptKeyName ("MoveToSizeColumn")), OT_HELP)
; msgc59 = "For hotkeys that can be used throughout Cakewalk press "
	Say (msgc59+(GetScriptKeyName ("GeneralHotKeyHelp")), OT_HELP)
;wc5 = "EV.2"
ElIf (GetWindowClass(GetFocus()) == wc5) then
	Say (msgc30, OT_HELP) ; "To hear the current event & move to next event press Shift+Spacebar"
; msgc59 = "For hotkeys that can be used throughout Cakewalk press "
	Say (msgc59+(GetScriptKeyName ("GeneralHotKeyHelp")), OT_HELP)

;wc6 = "SystreeView32"
ElIf (GetWindowClass(GetFocus()) == wc6) then
	Say (msgc60, OT_HELP) ; "To drag effects from the effects treeview to either the Effects Loops or Track Inserts"
; msgc60 = " Select the effect to drag, press "
	Say (msgc60+(GetScriptKeyName ("DragAndDrop")), OT_HELP)
	Say (msgc61, OT_HELP) ; " Press tab and select the effect loop or track insert you wish to place the effect in,"
	Say (msgc62+(GetScriptKeyName ("DragAndDrop")), OT_HELP)
; msgc59 = "For hotkeys that can be used throughout Cakewalk press ",
	Say (msgc59+(GetScriptKeyName ("GeneralHotKeyHelp")), OT_HELP)
Else
	PerformScript HotKeyHelp()
; msgc59 = "For hotkeys that can be used throughout Cakewalk press ",
	Say (msgc59+(GetScriptKeyName ("GeneralHotKeyHelp")), OT_HELP)
EndIf
EndScript

Script GeneralHotKeyHelp ()
	Say (msgc63, OT_HELP) ; "Use the following keys to read the desired information"
; msgc64 = "Time Format press "
	Say (msgc64+(GetScriptKeyName ("SayTimeFormat")), OT_HELP)
; msgc65 = "Now Time press "
	Say (msgc65+(GetScriptKeyName ("SayNow")), OT_HELP)
; msgc66 = "Select From Setting press "
	Say (msgc66+(GetScriptKeyName ("SayFrom")), OT_HELP)
; msgc67 = "Select Through Setting press "
	Say (msgc67+(GetScriptKeyName ("SayThrough")), OT_HELP)
; msgc68 = "Tempo press "
	Say (msgc68+(GetScriptKeyName ("SayTemp")), OT_HELP)
; msgc69 = "Tempo Ratio 1 press "
	Say (msgc69+(GetScriptKeyName ("SayRatio1")), OT_HELP)
; msgc70 = "Tempo Ratio 2 press "
	Say (msgc70+(GetScriptKeyName ("SayRatio2")), OT_HELP)
; msgc71 = "Tempo Ratio 3 press "
	Say (msgc71+(GetScriptKeyName ("SayRatio3")), OT_HELP)
	Say (msgc72, OT_HELP) ; "Use the following keys to change the tempo ratios"
; msgc73 = "Change Tempo Ratio 1 press "
	Say (msgc73+(GetScriptKeyName ("MoveToRatio1")), OT_HELP)
; msgc74 = "Change Tempo Ratio 2 press "
	Say (msgc74+(GetScriptKeyName ("MoveToRatio2")), OT_HELP)
; msgc75 = "Change Tempo Ratio 3 press "
	Say (msgc75+(GetScriptKeyName ("MoveToRatio3")), OT_HELP)
EndScript

Function IfEventNote ()
var 
	string strLine, 
	int nSafety, 
	int nRow, int nColumn
SaveCursor()
InvisibleCursor ()
RouteInvisibleToPc ()
let nRow = GetCursorRow()
let strLine = GetLine()
let nSafety = 0
;msgc82 = "Note"
if (StringContains (strLine, msgc82)) then
	return
else
	MoveToWindow(GetFocus())
;msg83 = "Kind"
	While (GetWord() != msgc83 && nSafety < 10)
		NextWord()
		let nSafety = nSafety + 1
	EndWhile

	NextLine()
	PriorWord()
	NextWord()

	let nColumn = GetCursorCol ()
	MoveTo(nColumn, nRow)
	SayFromCursor ()
endif

EndFunction

Script PlayEvent ()
{shift + space bar}
;wc5 = "EV.2"
if (GetWindowClass(GetFocus()) == wc5) then
		IfEventNote()
		NextLine()
endif
EndScript

Script SaySelectedText ()
var 
	int nColor, 
	String SelectedTracks

let SelectedTracks = ""

SaveCursor()
;wc4 = "TV.2"
if (GetControlID (GetFocus())==1 && GetWindowClass (GetFocus())==wc4) then
	InvisibleCursor()
	MoveToWindow(GetFocus())
	RestrictCursor (ON)
	NextLine()
	NextWord()
	RestrictCursor(OFF)

	While (GetWindowClass(GetCurrentWindow()) == "TV.2")
		let nColor = GetColorText()
		;msgc84 = "white"
		if (GetColorName(nColor) == msgc84) then
			let SelectedTracks = SelectedTracks + GetWord() + " "
		endif
		NextLine()
	EndWhile

	if (SelectedTracks == "") then
		Say (msgc76, OT_MESSAGE) ; "no selected tracks"
	else
		Say (msgc77, OT_MESSAGE) ; ("SelectedTracks are"
		Say (SelectedTracks, OT_BUFFER)
	endif
else
	PerformScript SaySelectedText()
endif
EndScript

Script FromIsNow ()
Say (msgc78, OT_MESSAGE) ; "from equals now"
{f9}
delay(5)
PerformScript SayFrom()
EndScript

Script ThroughIsNow ()
Say (msgc79, OT_MESSAGE) ; "through equals now"
{f10}
delay(5)
PerformScript SayThrough()
EndScript

Script NowIsFrom ()
Say (msgc80, OT_MESSAGE) ; "now equals from"
{f7}
delay(5)
PerformScript Sayfrom()
EndScript

Script NowIsThrough ()
Say (msgc81, OT_MESSAGE) ; "now equals through"
{f8}
delay(5)
PerformScript Saythrough()
EndScript
